<?php
if (file_exists(__DIR__ . '/.env')) {
    $env = file_get_contents(__DIR__ . '/.env');
    foreach (explode("\n", $env) as $line) {
        if (!trim($line) || strpos(trim($line),'#')===0) continue;
        $p = explode('=', $line, 2);
        if (count($p)===2) {
            $k = trim($p[0]); $v = trim($p[1]);
            if (!getenv($k)) putenv("$k=$v");
        }
    }
}
function pdo() {
    static $pdo=null;
    if ($pdo) return $pdo;
    $host = getenv('DB_HOST') ?: 'localhost';
    $db = getenv('DB_DATABASE') ?: 'ikkonstore_db';
    $user = getenv('DB_USERNAME') ?: 'root';
    $pass = getenv('DB_PASSWORD') ?: '';
    $dsn = "mysql:host=$host;dbname=$db;charset=utf8mb4";
    $pdo = new PDO($dsn, $user, $pass, [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION]);
    return $pdo;
}
function get_enc_key() {
    $k = getenv('ENC_KEY') ?: '';
    if (!$k) throw new Exception('ENC_KEY not set in .env');
    return substr(hash('sha256', $k, true), 0, 32);
}
function encrypt_data($plaintext) {
    $key = get_enc_key();
    $ivlen = openssl_cipher_iv_length('AES-256-CBC');
    $iv = openssl_random_pseudo_bytes($ivlen);
    $cipher = openssl_encrypt($plaintext, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $iv);
    return base64_encode($iv . $cipher);
}
function decrypt_data($b64) {
    $key = get_enc_key();
    $data = base64_decode($b64);
    $ivlen = openssl_cipher_iv_length('AES-256-CBC');
    $iv = substr($data, 0, $ivlen);
    $cipher = substr($data, $ivlen);
    return openssl_decrypt($cipher, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $iv);
}
