<?php
require_once __DIR__ . '/../config.php'; session_start();
$uid = $_SESSION['user_id'] ?? null;
if (!$uid) { echo 'not_logged_in'; exit; }
$payment_id = intval($_POST['payment_id'] ?? 0);
$type = $_POST['type'] ?? '';
$value = trim($_POST['value'] ?? '');
if (!$payment_id || !$type || !$value) { echo 'missing'; exit; }
$pdo = pdo();
// verify payment belongs to user and is paid
$stmt = $pdo->prepare('SELECT * FROM payments WHERE id=? AND user_id=? AND status="paid"');
$stmt->execute([$payment_id, $uid]); $pay = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$pay) { echo 'invalid_payment'; exit; }
// check product max_files
$prod = $pdo->prepare('SELECT * FROM products WHERE id=?'); $prod->execute([$pay['product_id']]); $product = $prod->fetch();
$max = intval($product['max_files'] ?? 1);
$cntStmt = $pdo->prepare('SELECT COUNT(*) FROM submissions WHERE payment_id=?'); $cntStmt->execute([$payment_id]); $current = intval($cntStmt->fetchColumn() ?: 0);
if ($current >= $max) { echo 'limit_reached'; exit; }
// validate formats
if ($type === 'telegram_token') {
    if (!preg_match('/^[0-9]+:[A-Za-z0-9_-]{35,}$/', $value)) { echo 'invalid_token'; exit; }
} else if ($type === 'whatsapp_number') {
    if (!preg_match('/^[\+\d][\d]{6,20}$/', $value)) { echo 'invalid_phone'; exit; }
} else { echo 'invalid_type'; exit; }
// insert
$ins = $pdo->prepare('INSERT INTO submissions (payment_id,user_id,type,value) VALUES (?,?,?,?)');
$ins->execute([$payment_id,$uid,$type,$value]);
echo 'ok';
