<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers/snippet_crypto.php';
session_start();
if (!isset($_SESSION['admin'])) { header('Location:/admin'); exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { echo 'POST only'; exit; }
$pdo = pdo();
$product_id = intval($_POST['product_id'] ?? 0);
$payment_id = intval($_POST['payment_id'] ?? 0);
$snippet_id = intval($_POST['snippet_id'] ?? 0);
if (!$product_id || !$payment_id) { echo 'missing'; exit; }
// load product
$ps = $pdo->prepare('SELECT * FROM products WHERE id=?'); $ps->execute([$product_id]); $prod=$ps->fetch(PDO::FETCH_ASSOC);
$files = json_decode($prod['files'] ?? '[]', true) ?: [];
$max_files = intval($prod['max_files'] ?? 1);
// check submissions count
$sc = $pdo->prepare('SELECT COUNT(*) FROM submissions WHERE payment_id=?'); $sc->execute([$payment_id]); $count = intval($sc->fetchColumn() ?: 0);
if ($count > $max_files) { echo 'Buyer submitted more than allowed.'; exit; }
// load snippet
$ss = $pdo->prepare('SELECT * FROM security_snippets WHERE id=?'); $ss->execute([$snippet_id]); $srow = $ss->fetch(PDO::FETCH_ASSOC);
if (!$srow) { echo 'snippet missing'; exit; }
$snippet_plain = decrypt_data($srow['encrypted_blob']);
if ($snippet_plain === false) { echo 'decrypt failed'; exit; }
// prepare tmp
$slug = 'pkg_' . time() . '_' . bin2hex(random_bytes(4));
$tmp = sys_get_temp_dir() . '/' . $slug; mkdir($tmp, 0700, true);
// copy files from source folder for this product slug (fallback to default)
$base_src = __DIR__ . '/../server/bots/source/' . ($prod['slug'] ?? 'default') . '/';
if (!is_dir($base_src)) $base_src = __DIR__ . '/../server/bots/source/default/';
foreach ($files as $fname) {
    $templatePath = $base_src . $fname;
    if (!file_exists($templatePath)) continue;
    $content = file_get_contents($templatePath);
    if (basename($fname) === 'index.js') {
        $content = "// === SECURITY SNIPPET INJECTED ===\n" . $snippet_plain . "\n// === END SNIPPET ===\n" . $content;
    }
    file_put_contents($tmp . '/' . basename($fname), $content);
    chmod($tmp . '/' . basename($fname), 0600);
}
// build setting.js from submissions
$subs = $pdo->prepare('SELECT * FROM submissions WHERE payment_id=?'); $subs->execute([$payment_id]); $subsRows = $subs->fetchAll(PDO::FETCH_ASSOC);
$setting = [];
foreach ($subsRows as $s) {
    if ($s['type'] === 'telegram_token') $setting['bot_token'] = $s['value'];
    if ($s['type'] === 'whatsapp_number') $setting['whatsapp_number'] = $s['value'];
}
$paymentStmt = $pdo->prepare('SELECT * FROM payments WHERE id=?'); $paymentStmt->execute([$payment_id]); $pay = $paymentStmt->fetch(PDO::FETCH_ASSOC);
$setting['license'] = $pay['license_key'] ?? '';
$setting['expiry'] = $pay['expiry_date'] ?? '';
file_put_contents($tmp . '/setting.js', "module.exports = " . json_encode($setting, JSON_PRETTY_PRINT));
chmod($tmp . '/setting.js', 0600);
// create zip
$zipname = sys_get_temp_dir() . '/' . $slug . '.zip';
$zip = new ZipArchive();
if ($zip->open($zipname, ZipArchive::CREATE)!==true){ echo 'zipfail'; exit; }
foreach (glob($tmp . '/*') as $f){ $zip->addFile($f, basename($f)); }
$zip->close();
// cleanup temp files
foreach (glob($tmp . '/*') as $f) unlink($f);
rmdir($tmp);
// optionally send via telegram to buyer
if (!empty($pay['tg_chat_id']) && getenv('TELEGRAM_BOT_TOKEN')) {
    $token = getenv('TELEGRAM_BOT_TOKEN');
    $chat = $pay['tg_chat_id'];
    $msg = 'Package ready. Download: ' . basename($zipname);
    @file_get_contents('https://api.telegram.org/bot'.$token.'/sendMessage?chat_id='.urlencode($chat).'&text='.urlencode($msg));
}
// deliver zip to admin for download
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . basename($zipname) . '"');
readfile($zipname);
unlink($zipname);
